Version 1/240717 of Why Pout Tables by Andrew Schultz begins here.

"Tables for Why Pout"

volume the main tables

book very general stuff

table of main oronyms
w1 (text)	w2 (text)	first-hom (text)	second-hom	hom-txt-rule (rule)	first-exact	first-close	second-exact	second-close	part-explain	think-cue	okflip	core	idid	everfail	best-room	check-rule	run-rule	wfull (topic)	think-advice (text)
"an"	"aim"	--	--	--	false	false	false	false	"any sort of purpose at all"	false	true	true	false	false	eh raw air aww	pre-an-aim rule	post-an-aim rule	--	--
"two"	"maps"	"too"	--	hom-too-maps rule	false	false	false	false	"anything documenting a way out"	false	true	true	false	false	eh raw air aww	pre-two-maps rule	post-two-maps rule	--	--
"self"	"owns"	--	--	--	false	false	false	false	"what to do with the cell phones"	false	true	true	false	false	hype lane	pre-self-owns rule	post-self-owns rule	--	--
"pry"	"stalk"	--	--	--	false	false	false	false	"something physical amidst the prize talk"	false	true	true	false	false	hype lane	pre-pry-stalk rule	post-pry-stalk rule	--	--
"high"	"plain|plane"	"hi"	"playin"	--	false	false	false	false	"where to go from Hype Lane"	false	true	true	false	false	hype lane	pre-high-plain rule	post-high-plain rule	--	"You can find a [b]HIGH PLAIN[r] [once-now of sco-pry-stalk] you have something that can reach that far up."
"nah|naah|naw|naa|na"	"phase"	--	"phaze"	hom-nah-phaze rule	false	false	false	false	"how to cut through the naff haze"	false	true	true	false	false	NaffHaze	pre-nah-phase rule	post-nah-phase rule	--	--
"pole|pull"	"east"	"poll|paul|pall"	--	--	false	false	false	false	"the source of your feeling policed"	false	true	true	false	false	NaffHaze	pre-pole-east rule	post-pole-east rule	--	--
"grow"	"star"	--	--	--	false	false	false	false	"making it beyond the gross tar"	false	true	true	false	false	NaffHaze	pre-grow-star rule	post-grow-star rule	--	--
"shore"	"trail"	--	--	--	false	false	false	false	"finding where the short rail could lead"	false	true	true	false	false	NaffHaze	pre-shore-trail rule	post-shore-trail rule	--	--
"key"	"pillar"	--	--	--	false	false	false	false	"finding a way into the keep"	false	true	true	false	false	NaffHaze	pre-key-pillar rule	post-key-pillar rule	--	--
"brew"	"swears"	--	--	--	false	false	false	false	"seeing [b]BRUISE WARES[r]'s true nature"	false	true	false	false	false	NaffHaze	pre-brew-swears rule	post-brew-swears rule	--	--
"known"	"ocean"	--	--	--	false	false	false	false	"finding the surroundings [here-in of NoNotion]"	false	true	true	false	false	NoNotion	pre-known-ocean rule	post-known-ocean rule	--	--
"six"	"quid"	--	--	--	false	false	false	false	"discovering what ails the sick squid"	false	true	true	false	false	NoNotion	pre-six-quid rule	post-six-quid rule	--	--
"war"	"file"	--	--	--	false	false	false	false	"what is on Wharf Isle"	false	true	true	false	false	nonotion	pre-war-file rule	post-war-file rule	--	"You may be able to recover the [b]WAR FILE[r] on the wharf isle [here-in of nonotion] [once-now of sco-plan-tracker] you have something you can write down its main ideas in."
"the"	"file"	"thee"	--	--	false	false	false	false	"what is on Thief Isle"	false	true	true	false	false	nonotion	pre-the-file rule	post-the-file rule	--	"You may be able to make sense of [b]THE FILE[r] [here-in of nonotion] [once-now of whether or not number of still-chat-needed followers is 0] you've gotten enough information from companions."
"grow"	"vial"	--	"vile"	--	false	false	false	false	"what is on Grove Isle"	false	true	true	false	false	nonotion	pre-grow-vial rule	post-grow-vial rule	--	"You may be able to find a [b]GROW VIAL[r] with the right water transport."
"wan"	"dwarf"	--	--	--	false	false	false	false	"who is on Wand Wharf"	false	true	true	false	false	wand wharf	pre-wan-dwarf rule	post-wan-dwarf rule	--	--
"wool"	"frock"	--	--	--	false	false	false	false	"what is hidden in Wolf Rock"	false	true	true	false	false	Wolf Rock	pre-wool-frock rule	post-wool-frock rule	--	--
"hide"	"out"	--	--	--	false	false	false	false	"how to dispel your high doubt"	false	true	true	false	false	Wolf Rock	pre-hide-out rule	post-hide-out rule	"hide out" or "hideout"	--
"low"	"door"	--	--	--	false	false	false	false	"what the lode ore is hiding"	false	true	true	false	false	Wolf Rock	pre-low-door rule	post-low-door rule	--	"You may be able to find a [b]LOW DOOR[r] [here-in of Wolf Rock] [once-now of sco-mice-tall] you have a companion or companions small enough to dig a bit better."
"well"	"own"	"wheel"	--	hom-wheel-own rule	false	false	false	false	"the sinister meaning behind We'll Own"	false	true	true	false	false	we loan	pre-well-own rule	post-well-own rule	--	--
"summer"	"chant"	--	--	--	false	false	false	false	"a way to zone some merchant out"	false	true	true	false	false	we loan	pre-summer-chant rule	post-summer-chant rule	--	--
"bile"	"oh|o"	--	"owe"	hom-bile-owe rule	false	false	false	false	"a way to counter the buy-low rhetoric"	false	true	true	false	false	we loan	pre-bile-oh rule	post-bile-oh rule	--	"You may be able to expose some merchant's [b]BILE OH[r] [once-now of sco-summer-chant] you've found something positive to say to prep yourself."
"whee"	"lone"	"wee|loan"	--	--	false	false	false	false	"a way to enjoy solitude"	false	true	true	false	false	we loan	pre-whee-lone rule	post-whee-lone rule	--	"You may be able to enjoy your solitude with [b]WHEE LONE[r] [here-in of we loan] [once-now of sco-bile-oh] you actually have solitude."
"oh"	"flier|flyer"	"owe"	--	hom-owe-flier rule	false	false	false	false	"a way to get something from the oaf liar"	false	true	true	false	false	we loan	pre-oh-flier rule	post-oh-flier rule	--	"You may be able to say [b]OH FLIER[r] around the oaf liar [if current-quid is 0]once you've got some money[else if gs-overpay-flier is true][once-now of whether or not current-quid is 1] you have exactly one quid left[else]since you have money[end if]."
"boost"	"role"	--	"roll"	--	false	false	false	false	"a way to make the booze troll feel less awful"	false	true	true	false	false	hideout	pre-boost-role rule	post-boost-role rule	--	--
"low"	"bend"	--	--	--	false	false	false	false	"a way to rearrange the landscape [here-in of lobe end]"	false	true	true	false	false	lobe end	pre-low-bend rule	post-low-bend rule	--	--
"bay"	"sail|sale"	--	--	--	false	false	false	false	"a way to repurpose the base ale"	false	true	true	false	false	lobe end	pre-bay-sale rule	post-bay-sale rule	--	"You may be able to participate in a [b]BAY SALE[r] if you've found the right location and [once-now of sco-six-quid] you have money." [?? very detailed fix: we need to set a boolean somehow if this was guessed in Lobe End ]
"store"	"mile"	--	--	--	false	false	false	false	"the storm isle's alternate nature"	false	true	true	false	false	storm isle	pre-store-mile rule	post-store-mile rule	--	--
"mensch"	"elf"	"mensh|mench|munch"	--	hom-mencsh-elf rule	false	false	false	false	"a nicer form of the MEN shelf"	false	true	true	false	false	storm isle	pre-mensch-elf rule	post-mensch-elf rule	--	--
"mice"	"tall"	--	--	--	false	false	false	false	"what's inside MY STALL"	false	true	true	false	false	storm isle	pre-mice-tall rule	post-mice-tall rule	--	"You may be able to locate the [b]MICE TALL[r] [here-in of storm isle] [once-now of sco-gnome-old] you have a companion with good perception."
"tree"	"small"	--	--	--	false	false	false	false	"something hidden [here-in of Trees Mall]"	false	true	true	false	false	trees mall	pre-tree-small rule	post-tree-small rule	--	--
"tall"	"cake"	--	--	--	false	false	false	false	"how to get rid of your talk-ache"	false	true	true	false	false	trees mall	pre-tall-cake rule	post-tall-cake rule	--	"You may be able to create a [b]TALL CAKE[r] [once-now of pre-tall-cake rule] you have ingredients and cooking instruments."
"treat"	"all"	--	"awl"	--	false	false	false	false	"what to do under the tree, tall"	false	true	true	false	false	trees mall	pre-treat-all rule	post-treat-all rule	--	"You may be able to [b]TREAT ALL[r] [here-in of trees mall] [once-now of sco-tall-cake] you have a tasty treat."
"gnome"	"old"	--	--	--	false	false	false	false	"who has made sure there's no mold"	false	true	true	false	false	keepiller	pre-gnome-old rule	post-gnome-old rule	--	"You may be able to recruit the [b]GNOME OLD[r] [here-in of keepiller] [once-now of sco-wool-frock] you have adventuring gear."
"rogue"	"old"	"rouge"	--	hom-rouge-old rule	false	false	false	false	"who is responsible for the row, gold"	false	true	true	false	false	keepiller	pre-rogue-old rule	post-rogue-old rule	--	"You may be able to recruit the [b]ROGUE OLD[r] [here-in of keepiller] [once-now of sco-six-quid] you have money."
"manna"	"curb|kerb"	"man a|mana"	--	hom-mana-curb rule	false	false	false	false	"what lies under or near the manic herb"	false	true	true	false	false	keepiller	pre-manna-curb rule	post-manna-curb rule	--	"You may be able to find a [b]MANNA CURB[r] beneath the manna curb [here-in of keepiller] [once-now of sco-mensch-elf] you have someone with knowledge of wildlife and wildflowers."
"plan"	"tracker"	--	--	--	false	false	false	false	"an alternate form of the plant racker"	false	true	true	false	false	keepiller	pre-plan-tracker rule	post-plan-tracker rule	--	--
"see"	"design"	"c|sea"	--	hom-c-sea-design rule	false	false	false	false	"what the sign hides"	false	true	true	false	false	keep iller	pre-see-design rule	post-see-design rule	--	"You may be able to [b]SEE DESIGN[r] [here-in of keepiller] [once-now of whether or not pals-made >= 2] you have more support and are less scared."
"knife"	"right|rite"	--	--	--	false	false	false	false	"what to find or do to leave"	false	true	true	false	false	nigh fright	pre-knife-right rule	post-knife-right rule	--	--
"gaunt"	"raider"	--	"rater"	hom-gaunt-rater rule	false	false	false	false	"who the traitor was or can become"	false	true	true	false	false	worm eaten	pre-gaunt-raider rule	post-gaunt-raider rule	--	--
"were"	"meetin"	"wier|whirr|warm|eden|war|meeting"	--	hom-whirr-meetin rule	false	false	false	false	"how Worm Eaten could feel more homey"	false	true	true	false	false	worm eaten	pre-were-meetin rule	post-were-meetin rule	--	"You will be able to say [b]WERE MEETIN[r] [once-now of pre-were-meetin rule] you have a full party available."
"my"	"corps"	--	"core"	hom-my-core rule	false	false	false	false	"why your name is special"	false	true	true	false	false	worm eaten	pre-my-corps rule	post-my-corps rule	--	"You can call your companions [b]MY CORPS[r] [if pals-made < 2]once you have companions[else if pals-made < pals-needed]once you have enough of them[else][once-now of sco-treat-all] you've shared something together[end if]."
"cease"	"cull"	"seas|sees|seize"	--	hom-cease-cull rule	false	false	false	false	"alerting the sea skull"	false	true	true	false	false	Doom Ending	pre-cease-cull rule	post-cease-cull rule	--	--
"wipe"	"out"	--	--	--	false	false	false	false	"how to [if player is in doom ending]take down the skull[else]do something generally awesome down the road[end if]"	false	true	true	false	false	Doom Ending	pre-wipe-out rule	post-wipe-out rule	--	"You will want to [b]WIPE OUT[r] the cause of your problems [once-now of sco-cease-cull] you have them in your crosshairs[if the room down from naffhaze is nowhere]. That's probably not for a while, though[end if]."
"wide"	"vision"	--	--	--	false	false	false	false	"something more positive than the why-division"	false	true	false	false	false	Doom Ending	pre-wide-vision rule	post-wide-vision rule	--	"Sadly, you didn't quite experience enough to spread your wide vision."
"do|due"	"mend|mending"	--	"dew"	--	false	false	false	false	"a way to steer things from a doom ending"	false	true	true	false	false	Doom Ending	pre-do-due-mend rule	post-do-due-mend rule	--	"You can think [b]DO/DUE MEND/MENDING[r] [once-now of sco-wipe-out] you've disposed of the sea skull."
"weak"	"us"	--	--	--	false	false	false	false	"how to deflate [the earls]['] bravado"	false	true	false	false	false	brew swears	pre-weak-us rule	post-weak-us rule	--	--
"grin"	"churls"	--	--	--	false	false	false	false	"a way to reclassify the grinch earls"	false	true	false	false	false	brew swears	pre-grin-churls rule	post-grin-churls rule	--	--
"crew"	"dork"	--	--	--	false	false	false	false	"a way to explain the crude orc's status"	false	true	false	false	false	brew swears	pre-crew-dork rule	post-crew-dork rule	--	"[if doom ending is visited][dork-lockout][else]You can explain [the earls] see the crude orc as a [b]CREW DORK[r] [once-now of sco-weak-us] they seem a bit less strong[end if]."
"ass"	"low|lo"	--	--	--	false	false	false	false	"a way to counter the ah-slow taunts"	false	true	false	false	false	brew swears	pre-ass-low rule	post-ass-low rule	--	--
"bastard"	"e+h*"	--	--	--	false	false	false	false	"a way to counter the bah-sturdy taunts"	false	true	false	false	false	brew swears	pre-bastard-eee rule	post-bastard-eee rule	--	--
"heckle"	"ass"	--	--	--	false	false	false	false	"a way to counter the heh-class taunts"	false	true	false	false	false	brew swears	pre-heckle-ass rule	post-heckle-ass rule	--	--
"huh"	"shit"	--	--	--	false	false	false	false	"a way to counter the hush-it taunts"	false	true	false	false	false	brew swears	pre-huh-shit rule	post-huh-shit rule	--	--
"lie"	"fuckers"	--	--	--	false	false	false	false	"a way to counter the life-occurs taunts"	false	true	false	false	false	brew swears	pre-lie-fuckers rule	post-lie-fuckers rule	--	--
"were"	"dicks"	--	--	--	false	false	false	false	"a way to counter the taunting weird-icks"	false	true	false	false	false	brew swears	pre-were-dicks rule	post-were-dicks rule	--	--
"gah"	"wanker"	--	--	--	false	false	false	false	"a way to counter Gawain Kerr's taunts"	false	true	false	false	false	brew swears	pre-gah-wanker rule	post-gah-wanker rule	--	--

section main table text replacements

to say dork-lockout:
	say "You lost the chance to say [b]CREW DORK[r] to the crude orc a bit more gently, [if sco-weak-us is true]even though you weakened[else]as you didn't figure a way to diminish[end if] [the earls]"

section air aww scoring

a wordtwisting rule (this is the pre-two-maps rule):
	if player is not in air aww or sco-an-aim is false, unavailable;
	ready;

this is the hom-too-maps rule:
	say "Sounds right, but be more specific how MUCH of ";
	if the player's command includes "maps":
		say "the maps";
	else:
		say "something else";
	say " you want."

this is the post-two-maps rule:
	now sco-two-maps is true;
	say "You look around for secrets. First, you find two pages, one a hash of horizontal lines and another that is a hash of vertical lines. You put them together ... and you see a maze. You hope you can trace a passage out.[paragraph break]You do! But first, you notice, under the pages, a pair of weird mechanical eyes: sly size-slice eyes! They seem quite observant, and best, they don't seem to be surveilling YOU.[paragraph break]You poke around a bit, hoping for even more help. But that is all. So you follow the map, hopefully to somewhere better, or not as forbidding ...";
	declue-here;
	now player has eyes;
	move player to Hype Lane;

section unsorted scoring

a wordtwisting rule (this is the pre-boost-role rule):
	if new troll is touchable and sco-boost-role is true and player is not in doom ending:
		vcal "You already gave the new troll a boost!";
		already-done;
	if booze troll is not touchable, unavailable;
	ready;

this is the post-boost-role rule:
	now sco-boost-role is true;
	say "You talk with the booze troll for a bit. They seem not to know who they are, and that gives you something in common with them. They don't want to be a lousy boozer all their life. They are sick of drinking Base Ale.[paragraph break]You decide to trust them. They don't seem armed. You mention you've been having an adventure, and they'd sort of like one, too. They hand you a bottle of Base Ale as thanks. Not that they want you to go down their road. But it might be useful in bartering.";
	befriend new troll;
	moot booze troll;
	now player has Base Ale;

section eh raw air aww scoring

a wordtwisting rule (this is the pre-an-aim rule):
	if sco-an-aim is true:
		vcal "You already found a name and an aim!";
		already-done;
	ready;

this is the post-an-aim rule:
	now sco-an-aim is true;
	say "Yes. Now that you realize you want more than just to know your name, that you have bigger goals, you push a bit harder when you initially forget it. You remember patches of the past. You remember people harshly calling you by your last name, then your first.[paragraph break]Your name is Mike Orr. You even remember it's -- well, one of these two things: short for Michal, which everyone pronounced Michael until you just gave up, or ... well, Michael.[paragraph break]You look around a bit. You can see more, now. You're in some sort of tomb apse. You could exit--there are exits each way--but you suspect there's some horrible maze you could easily get lost in.";
	now eyes-number of mike orr is 25;
	now eyes-number of air aww is 34; [technically, we can't see it with the eyes.]
	now eyes-rule of mike orr is pre-my-corps rule;
	now eyes-rule of air aww is pre-two-maps rule;
	print-the-loc;

section NaffHaze scoring

a wordtwisting rule (this is the pre-pole-east rule):
	if player is not in naffhaze, unavailable;
	if sco-nah-phase is false, unavailable;
	if sco-pole-east is true:
		vcal "You already discovered how you were being policed!";
		already-done;
	ready;

this is the post-pole-east rule:
	now sco-pole-east is true;
	say "Ah, yes. It makes sense. You find the pole. Strangely, there's just a single switch to flip. And even more strangely, the switch you flip causes the pole to revert into the ground. Yay![paragraph break]But there's more! A war pawn, like a chess piece, rolls into view. It looks pretty powerful. As you take it, you reflect that you may wish to save it for down the road when you're really stuck somewhere. You have a good idea HOW to use it, at any rate.";
	say "[line break][i][bracket][b]NOTE[r][i]: the war pawn is a one-use item, with [b]UNDO[r][i] is disabled for it. You can save before using it, and I won't judge. I've done so before, too, but I don't want to make it too powerful.[close bracket][r][line break]";
	now player has war pawn;
	reveal Lobe End to east;
	declue-here;
	check-worm-eaten;

a wordtwisting rule (this is the pre-shore-trail rule):
	if player is not in NaffHaze, unavailable;
	if sco-nah-phase is false, unavailable;
	if sco-shore-trail is true:
		vcal "But you already replaced the short rail!";
		already-done;
	ready;

this is the post-shore-trail rule:
	now sco-shore-trail is true;
	say "There must be more to the short rail than you see. And you start tracing where it is, where it can be, where it should go. You find something to dig up. It's ... surprisingly malleable. You have nothing else to do, anyway. Soon it feels like pulling cable from a ground. It's tough, since you can't see around, but indeed, the short rail does lead to a shore trail that leads south.";
	moot short rail;
	move shore trail to NaffHaze;
	reveal NoNotion to south;
	check-worm-eaten;

a wordtwisting rule (this is the pre-grow-star rule):
	if player is not in NaffHaze, unavailable;
	if sco-nah-phase is false, unavailable;
	if sco-grow-star is true:
		vcal "You already got rid of the tar!";
		already-done;
	ready;

this is the post-grow-star rule:
	now sco-grow-star is true;
	say "You look at the gross tar, and you hope for a star in the sky to become brighter. It does, and clearly some of the tar is goopier than some of the other tar. You see a way to the north, and after you do, the tar isn't as relevant any more.";
	moot gross tar;
	reveal Wolf Rock to north;
	check-worm-eaten;

a wordtwisting rule (this is the pre-wipe-out rule):
	if sco-wipe-out is true:
		vcal "You already wiped out the sea skull! Now is the time for healing.";
		already-done;
	if pals-made is 0:
		vcp "You aren't feeling too great, but you don't want or need to wipe yourself out, yet. Perhaps you can find the root of your problems and wipe it out one day, though.";
		not-yet;
	if number of still-follow-needed followers > 0:
		vcp "You don't want to wipe out the friendship[if number of friendly followers > 1]s[end if] you made.";
		not-yet;
	if player is not in Doom Ending:
		vcp "You haven't identified anyone terribly evil you want to wipe out.";
		not-yet;
	if sco-cease-cull is false:
		vcp "You try to charge and wipe out the sea skull, but you bounce against an invisible barrier. It's likely protecting itself from sneak attacks. You'll have to get its attention.";
		not-yet;
	ready;

this is the post-wipe-out rule:
	now sco-wipe-out is true;
	say "Easier said than done, but since you all studied the plan tracker so well, it isn't impossible![paragraph break]Your makeshift weapons are just enough to distract the sea skull. It starts to focus on one party member, then the others taunt it, and it turns away. It's exhausting for you but even more exhausting for the skull, which eventually collapses and incinerates, but not before a self-pitying 'Meek old me! Cold!'[paragraph break]But after all the fireworks, there's a letdown. You feel something odd come between you and your companions now you're done. They wonder why they need to do any more. You could call the whole zeitgeist a why-division.";
	move why division to Doom Ending;
	moot sea skull;

chapter Wolf Rock scoring

a wordtwisting rule (this is the pre-wool-frock rule):
	if player is not in wolf rock, unavailable;
	if sco-wool-frock is true:
		vcal "You already found one wool frock. You can't imagine you'd need two.";
		already-done;
	ready;

this is the post-wool-frock rule:
	now sco-wool-frock is true;
	say "You rummage about and find a wool frock.";
	now player has wool frock;
	if sco-hide-out is false:
		now eyes-number of Wolf Rock is 43;
		say "[line break]The high doubt still haunts you, though.";
	else:
		declue-here;

a wordtwisting rule (this is the pre-hide-out rule):
	if player is not in Wolf Rock, unavailable;
	if sco-hide-out is true:
		vcal "You already dispelled doubt and found the hideout!";
		already-done;
	ready;

this is the post-hide-out rule:
	now sco-hide-out is true;
	say "It's easy enough to say you should doubt yourself less. I mean, you'd feel stupid doubting it. But there's always a reason not to. Still, you involuntarily start a mantra: 'Fine, doubt? Find out!'[paragraph break]And what do you know? You find a hideout below!";
	reveal hideout to down;
	moot high doubt;
	if sco-wool-frock is true, declue-here

a wordtwisting rule (this is the pre-low-door rule):
	if player is not in Wolf Rock, unavailable;
	if sco-mice-tall is false:
		vcp "Maybe there's a low door beneath the lode ore, which definitely has small holes. But not small enough for you to fit through and scrabble and scrape to find one[if pals-made > 0], and nobody around is quite small enough to help you. Well, yet[end if].";
		not-yet;
	if sco-low-door is true:
		vcal "You already found a low door in this mess!";
		already-done;
	ready;

this is the post-low-door rule:
	now sco-low-door is true;
	say "The lode and the ore are tough to shift around for someone as big as yourself. But the tall mice manage to get into those small niches you can't. And they work so fast, you daren't even ironically say 'My! Slow mice, lo!'[paragraph break]They locate a low door, then, point to where you can remove the ore to create a passage. You'll have to duck a bit to get in, but you can now go [b]INSIDE[r]. Hooray!";
	reveal We Loan to inside;
	declue lode ore;

section lobe end scoring

a wordtwisting rule (this is the pre-low-bend rule):
	if player is not in lobe end, unavailable;
	if sco-low-bend is true:
		vcal "You already found a low bend!";
		already-done;
	ready;

this is the post-low-bend rule:
	now sco-low-bend is true;
	say "You almost despair for a minute that you reached a dead end so soon. You page through all the possible ways out, proving to yourself you're right, hoping against hope you're wrong.[paragraph break]And looking around, you see you are! There is a bit more to all this. A very thin and reasonably sloped path north leads down to some water. Which you can't cross at the moment, but maybe you'll figure a way.";
	print-the-loc;
	now eyes-number of lobe end is 34;

section lobe end scoring

a wordtwisting rule (this is the pre-bay-sale rule):
	if player does not have base ale, unavailable;
	if player is in NoNotion:
		vcp "[if sco-known-ocean is true]There's water here, but it's much more than a bay[else]You can't make out what sort of body of water is here. Well, not yet[end if].";
		not-yet;
	if player is not in lobe end:
		vcp "No water here. Maybe somewhere else.";
		not-yet;
	if player is in lobe end and sco-low-bend is false:
		vcp "No water visible here right now. Maybe if the landscape rearranged.";
		not-yet;
	if sco-six-quid is false:
		vcp "You realize that, in order to participate in a bay sale for a bay sail, you need some form of currency. You don't have that yet.";
		not-yet;
	ready;

this is the post-bay-sale rule:
	now sco-bay-sale is true;
	say "You have money, and you are ready for a sale, and you get it. Unfortunately, though you were expecting a nice big ship, you get something a little humbler, namely a We-Craft Weak Raft. It seems sturdy enough, though, and it does have a sail.[paragraph break]You christen it with the base ale, and the bottle fragments shatter and float away in the water.";
	quid-reduce 2;
	moot base ale;
	move We Craft Weak Raft to lobe end;
	move water north to Lobe End;
	reveal Storm Isle to north;
	declue-here;

section storm isle scoring

a wordtwisting rule (this is the pre-store-mile rule):
	if player is not in storm isle, unavailable;
	if sco-store-mile is true:
		vcal "But you already transformed the storm isle!";
		already-done;
	ready;

this is the post-store-mile rule:
	now sco-store-mile is true;
	say "The storms let up. It's not such a big isle after all, but it does turn out to hold a whole lot of stores and vending areas. In particular, a stall labeled MY STALL, and a shelf labeled MEN SHELF.";
	move my stall to storm isle;
	move men shelf to storm isle;
	reveal Trees Mall to north;
	print-the-loc;
	declue-here;

a wordtwisting rule (this is the pre-mice-tall rule):
	if player is not in storm isle, unavailable;
	if sco-store-mile is false, unavailable;
	if sco-gnome-old is false:
		vcp "Maybe there are mice behind there, but you can't figure a way to locate them. It requires some sort of clever inhuman perception, you'd think.";
		not-yet;
	if sco-mice-tall is true:
		vcal "You already found the mice and destroyed the stall!";
		already-done;
	ready;

this is the post-mice-tall rule:
	now sco-mice-tall is true;
	say "You look into the stall and shrug your shoulders. Then the gnome (old) steps in and notes they hear something. Chittering noises! The gnome chitters back.[paragraph break]It takes a lot of negotiating, but you find where the mice are stuck. You and the gnome thud through and out come some mice, tall. They're tall for mice, though they really only come up above your knee.";
	befriend mice tall;
	moot my stall;

a wordtwisting rule (this is the pre-mensch-elf rule):
	if player is not in storm isle, unavailable;
	if sco-store-mile is false, unavailable;
	ready;

this is the hom-mencsh-elf rule:
	if the player's command includes "munch":
		say "No, a sort of person. This one's a bit obscure.";
	else:
		say "Oh, man. Sorry to be playing spelling police with you here, but you have the pronunciation right."

this is the post-mensch-elf rule:
	now sco-mensch-elf is true;
	say "You knock about the MEN shelf a bit, unable to find anything. It's really a collection of shelves that you disassemble and reassemble. Eventually, you're about to give up, and it all collapses, taking a chunk of wall with it. Our pops a mensch elf, quite grateful you helped them escape.[paragraph break]They mention their nigh self was a nice elf, but they want to be so much more!";
	moot men shelf;
	befriend mensch elf;

section trees mall scoring

a wordtwisting rule (this is the pre-tree-small rule):
	if player is not in trees mall, unavailable;
	if sco-tree-small is true:
		vcal "You already got a tree (small) to grow!";
		already-done;
	ready;

this is the post-tree-small rule:
	now sco-tree-small is true;
	say "Amidst all the fake trees, an actual organic small tree grows. You're a bit disappointed, but you realize you maybe shouldn't have expected much with so little letter-shuffling. Maybe if you want a bigger tree, you'll need to do something else.";
	move tree small to Trees Mall;
	if player has grow vial, say "[line break]";
	declue-here;
	grow-the-tree;

a wordtwisting rule (this is the pre-tall-cake rule):
	if player does not have talk ache, unavailable;
	if player does not have manna and player has knife:
		vcp "You need ingredients to make a cake.";
		not-yet;
	if player has manna and player does not have knife:
		vcp "You need some sort of utensil to process the manna.";
		not-yet;
	if player does not have manna and player does not have knife:
		vcp "You have neither the utensils nor the ingredients to make a cake.";
		not-yet;
	ready;

this is the post-tall-cake rule:
	now sco-tall-cake is true;
	say "All this preparing food means you don't talk a bit, and as a bonus, your talk-ache is gone.[paragraph break]But now where to eat the cake?";
	moot talk ache;
	moot manna;
	now player has tall cake;

section trees mall scoring

a wordtwisting rule (this is the pre-treat-all rule):
	if tree tall is not in trees mall, unavailable;
	if player is in doom ending, unavailable;
	if sco-treat-all is true:
		vcal "You already shared treats!";
		already-done;
	if player does not have tall cake:
		vcp "You don't have anything to treat your companions with!";
		not-yet;
	if player is not in trees mall:
		vcp "You have the treat. Why not go back to the tree?";
		not-yet;
	ready;

this is the post-treat-all rule:
	now sco-treat-all is true;
	say "Wow, man! That was some good cake! Everyone shares more of their background over this meal.[paragraph break]The gaunt raider, in particular, has a lot to say, of past things they did that were horrible, that they think they're sorry for, but maybe not enough. Everyone assures the raider that they're the good guys now.[paragraph break]You offer the gaunt raider the knife (right) as a present. They seem scared to take it, but it doesn't burst into flames when they take it, so ... it must be right for them.";
	moot tall cake;
	moot knife right;
	declue tree tall;

section hype lane scoring

a wordtwisting rule (this is the pre-self-owns rule):
	if player is not in hype lane, unavailable;
	if cell phones are not in hype lane, unavailable;
	ready;

this is the post-self-owns rule:
	now sco-self-owns is true;
	say "You take a step back from all the confident, constant chatter in the cell phones. You hear that, indeed, people are just repeating mantras, and they are not as smart as they think they are. You wonder if you should say something to the most egregious offenders ... and you eventually do! And they appear flustered. They attack you back for being too quiet. You mention that if they annoyed someone as too-quiet as you, they must have gone over the line.[paragraph break]Your confrontation did not go unnoticed by other cell phoners. They take the hint and moderate their voices.[paragraph break]However, now, a prize talk blasts through hidden loudspeakers. It exhorts you to find your dream, to find something that will help you move above and beyond everyone else. It's probably talking about money or power, but you're looking for something different.";
	move prize talk to hype lane;
	moot cell phones;

a wordtwisting rule (this is the pre-pry-stalk rule):
	if player is not in hype lane, unavailable;
	if prize talk is not in hype lane, unavailable;
	if sco-pry-stalk is true:
		vcal "You already pried a stalk!";
		already-done;
	ready;

this is the post-pry-stalk rule:
	now sco-pry-stalk is true;
	now player has stalk;
	say "Among all the chatter, you discover a disused booth. Someone is preaching on about environmental stuff, and it's so much less painful than cell phone chat. You worry they're just going to blab on forever, but they're so grateful you listened as long as you did. They hand you a stalk they think can grow quickly. Their own special formula. It looks weird and glittery, and if anything can reach up out of here, this can. But the question is, where can it grow to?";
	declue prize talk;

a wordtwisting rule (this is the pre-high-plain rule):
	if player is not in hype lane, unavailable;
	if sco-pry-stalk is false:
		vcp "That would be a nicer place! But you have nothing that could help you move up yet. You'll have to observe the general area a bit more.";
		not-yet;
	ready;

this is the post-high-plain rule:
	now sco-high-plain is true;
	say "You plant the stalk, which -- well, it's already a bit of a stalk, but it grows quickly and sturdily. It's not hard at all to climb. You are pretty sure you're aboveground, but it's hard to see for sure.";
	moot stalk;
	declue-here;
	move player to NaffHaze;

section naff haze testing

a wordtwisting rule (this is the pre-nah-phase rule):
	if player is not in NaffHaze, unavailable;
	if sco-nah-phase is true:
		vcal "You already dispelled the haze!";
		already-done;
	ready;

this is the hom-nah-phaze rule:
	say "You sense you don't want the naff haze to faze you, but you want a noun, here, to reject."

this is the post-nah-phase rule:
	now sco-nah-phase is true;
	moot naff haze;
	say "The haze seemed too thick at first. But you recognize it doesn't have to be there. As you sift through it, you notice things that weren't there before. It lifts.";
	move short rail to NaffHaze;
	move gross tar to NaffHaze;
	move keep iller to NaffHaze;
	try looking; [pole east is implicitly moved that way]
	now eyes-number of NaffHaze is 44; [pole east]
	now eyes-rule of naffhaze is the pre-pole-east rule;

a wordtwisting rule (this is the pre-key-pillar rule):
	if player is not in NaffHaze, unavailable;
	if sco-nah-phase is false, unavailable;
	if sco-key-pillar is true:
		vcal "You already opened the keep (iller)!";
		already-done;
	ready;

this is the post-key-pillar rule:
	now sco-key-pillar is true;
	say "You look around the pillars for a key, since there's no flowerpot to hide it under. You find one, and once it unlocks the way west, you hide it, again.";
	reveal KeepIller to west;
	declue keep iller;
	check-worm-eaten;

to check-worm-eaten:
	if plane-dir-score is 4:
		say "[line break]You've changed the landscape a lot, north, south, east and west. But there's more! You hear a rumbling beneath you, opening a passage [b]DOWN[r]!";
		reveal Worm Eaten to down;
		move waydown to naffhaze;

section naffhaze scoring

a wordtwisting rule (this is the pre-brew-swears rule):
	if player is not in NaffHaze, unavailable;
	if Bruise Wares is not in NaffHaze, unavailable;
	if sco-brew-swears is true:
		vcal "But you've already opened the passage through [b]BRUISE WARES[r]!";
		already-done;
	ready;

this is the post-brew-swears rule:
	now sco-brew-swears is true;
	say "Yes. That's what [b]BRUISE WARES[r] is really for. Enter at your own risk. It's ... an adventure, of its own sort.";
	reveal Brew Swears to inside;

section no notion scoring

a wordtwisting rule (this is the pre-known-ocean rule):
	if player is not in NoNotion, unavailable;
	if sco-known-ocean is true:
		vcal "But you already got a notion for the ocean. And you didn't even need a potion!";
		already-done;
	ready;

this is the post-known-ocean rule:
	now sco-known-ocean is true;
	say "Ah, yes. Things clear up a bit now. There we go ... you see where an ocean should be, and ... yes, you dip your toe in some wetness. Things clear up. You even see a sick squid! Maybe you can help it.";
	move sick squid to NoNotion;
	move ocean to NoNotion;
	print-the-loc;
	declue-here;

a wordtwisting rule (this is the pre-six-quid rule):
	if player is not in nonotion, unavailable;
	if sco-known-ocean is false, unavailable;
	if sco-six-quid is true:
		vcal "You don't need any more money, and the squid doesn't need any more help.";
		already-done;
	ready;

this is the post-six-quid rule:
	now sco-six-quid is true;
	say "You have an idea what is bothering the squid. Yes, a few coins stuck. Surprisingly, it lets you help out. 'Current, sea, currency,' you mutter as you poke around. Ah, there you go.[paragraph break]You offer to give it some of the coins it almost choked on, but it does not need them. It seems to wait around, as if to help you with travel to places you may get to go. It's willing to wait.[paragraph break]";
	now current-quid is 6;
	declue sick squid;

[to check-squid-flier:
	if player has maps:
		say "[line break]The squid gestures towards the two maps, as if it can take you wherever you need to on the maps. But it does look a little exhausted. So you don't just want to summon it for a joyride.";]

a wordtwisting rule (this is the three-isle rule):
	if player does not have flier, unavailable;
	if (player is in lobe end or player is in storm isle) and sco-low-bend is true:
		vcp "No, there's water here, but this can't be the right place.";
		not-yet;
	if player is not in nonotion:
		vcp "This isn't the right place to look for an isle. No large body of water nearby.";
		not-yet;

to conditional-flier-mangle:
	if flier-isle-score is 2:
		if sco-grow-vial is false:
			now eyes-number of flier is 44;
		else: [maybe not necessary but I don't want things going bad if I change flier's default eyes-number]
			now eyes-number of flier is 34;
	if flier-isle-score is 3:
		say "[line break]You've visited all the locations in the flier. You crumple it up as if to throw it in a trash bin. The squid makes a gesture as if it wishes to gobble the flier. You're worried it might choke on the flier, as it did for the quid, but then -- well, the water washes the paper brochure down. Odd, but hooray for clearer inventory.";
		moot flier;

a wordtwisting rule (this is the pre-war-file rule):
	if sco-war-file is true and player has flier:
		vcp "You already got the war file. See where else you can visit.";
		already-done;
	abide by the three-isle rule;
	if sco-plan-tracker is false:
		vcp "A war file might be useful, but you'd have no way to organize the information right now.";
		not-yet;
	ready;

this is the post-war-file rule:
	now sco-war-file is true;
	say "The squid gives you[if number of friendly followers is 1] and [the random friendly follower][else if number of friendly followers > 1] and your companions[end if] a ride a few miles across the ocean. You realize you could reach the wharf isle for a war file.[paragraph break]When you get there, you're a bit disappointed by what you see. There's a bit too much emphasis on magic and the implements thereof, all of which are at a much too hefty price for you. So buying equipment is out.[paragraph break]Still, there are many ideas worth tracking. Your companions help with the process, offering ideas you're pleasantly surprised to hear.[paragraph break]You write the main stuff into your plan tracker, and as you do, you realize part of the plan points to having another party member not in your entourage. Well, yet. Perhaps someone else here has read the war file and maybe found less splashy ways to fight. You stay to look around...";
	move player to Wand Wharf;
	ride-squid;

a wordtwisting rule (this is the pre-the-file rule):
	if sco-the-file is true and player has flier:
		vcp "You already got THE FILE. See where else you can visit.";
		already-done;
	abide by the three-isle rule;
	if number of still-chat-needed followers > 0:
		vcp "You know there is THE FILE, but which file is THE FILE? The thief isle has probably stolen a lot! You need information from your companions[if number of still-follow-needed followers > 0], or maybe just more companions[end if].";
		not-yet;
	ready;

this is the post-the-file rule:
	now sco-the-file is true;
	say "You have a clue what isle to look through. The thief isle. You get The File.";
	conditional-flier-mangle;

to ride-squid:
	if player is in Wand Wharf:
		if pals-made >= 1:
			say "There was more than enough room on the squid for [if pals-made is 1][the random friendly follower][else if pals-made is 2]both your companions[else]all your companions[end if], too.";
	follow-you;

a wordtwisting rule (this is the pre-grow-vial rule):
	if sco-grow-vial is true and player has flier:
		vcp "You already got the grow vial. See where else you can visit.";
		already-done;
	abide by the three-isle rule;
	ready;

this is the post-grow-vial rule:
	now sco-grow-vial is true;
	say "In the grove isle, you find a grow vial, which you take. It's relaxing, but you can't afford to loiter too long.";
	now player has grow vial;
	conditional-flier-mangle;

chapter wand wharf scoring

a wordtwisting rule (this is the pre-wan-dwarf rule):
	if player is not in wand wharf, unavailable;
	ready;

this is the post-wan-dwarf rule:
	now sco-wan-dwarf is true;
	say "You look around and uncover a wan dwarf who wasn't good enough to be a full fighter but was rejected for magic training. You show them the plan tracker with the notes you wrote from the war file, with input from your followers.[paragraph break]The wan dwarf thinks for a minute, then starts filling in some blanks in your plan. Not to criticize, just ... you thought of some things they didn't, and they thought of some you didn't.[paragraph break]There's not much left to do here, so you ride the squid back.";
	befriend wan dwarf;
	declue-here;
	move player to NoNotion;

chapter we loan scoring

a wordtwisting rule (this is the pre-well-own rule):
	if player is not in we loan, unavailable;
	if sco-well-own is true:
		vcal "You already exposed the shady side here.";
		already-done;
	ready;

this is the hom-wheel-own rule:
	say "This is a seedy financial services provider, not a seedy used car dealer. Still, you must be on the right track."

this is the post-well-own rule:
	now sco-well-own is true;
	say "Yes. There's a definite shady side. You mumble to yourself, and then your mumbles get louder, and it attracts ... some merchant. They begin babbling about deals they have, fake-friendly, about how you can buy low.";
	move some merchant to We Loan;
	print-the-loc;
	now eyes-number of We Loan is 44;
	now eyes-rule of we loan is the pre-whee-lone rule;

a wordtwisting rule (this is the pre-summer-chant rule):
	if player is not in we loan or merchant is not in we loan, unavailable;
	if sco-summer-chant is true:
		vcal "You already found cheeriness outside of the merchant!";
		already-done;
	ready;

this is the post-summer-chant rule:
	now sco-summer-chant is true;
	say "You think up a summer chant you mumble under your breath. The merchant finds it a bit weird you like THAT as a way to keep positive. It doesn't seem like that sort of thing helps the economy. Their cheeriness slips slightly, with impressively-balanced potshots at people more and less successful than they are.";
	now eyes-number of merchant is 42;
	now eyes-rule of some merchant is the pre-bile-oh rule;

a wordtwisting rule (this is the pre-bile-oh rule):
	if player is not in we loan or merchant is not in we loan, unavailable;
	if sco-summer-chant is false:
		vcp "You need to find something positive to say, first. It doesn't have to be particularly rigorous, but it needs to be positive.";
		not-yet;
	ready;

this is the hom-bile-owe rule:
	say "Neither you nor the merchant owe each other anything, for better or for worse. You're close. Perhaps you should just see things as they are and emote slightly."

this is the post-bile-oh rule:
	now sco-bile-oh is true;
	say "The mere suggestion that the merchant's aggression may be annoying seems to set them off. No, no, it's people like YOU who are the problem. Without dynamic positivity like theirs, you're totally screwed! You're just jealous you don't have it! Just like other lesser people when the merchant walks in to the room! On some level, they KNOW![paragraph break]You freeze up, confused by all this, and the merchant takes this as a sign of arrogant disrespect. You are not the first person to reject their positivity! They run into clueless crumb-bums all day![paragraph break]They storm off, presumably to find another crumb-bum to abuse for not having their brand of positivity.[paragraph break]Oh, hey, you can maybe enjoy some solitude now!";
	moot merchant;

a wordtwisting rule (this is the pre-whee-lone rule):
	if player is not in we loan, unavailable;
	if sco-well-own is false:
		vcp "It's nice to be alone here. But you sense there's a challenge here, to earn solitude, first.";
		not-yet;
	if merchant is in we loan:
		vcp "You can't enjoy solitude with that merchant around.";
		not-yet;
	if sco-whee-lone is true:
		vcal "You already got this place to yourself!";
		already-done;
	ready;

this is the post-whee-lone rule:
	now sco-whee-lone is true;
	say "You enjoy your solitude, but ... wait. You lose track of time, and an oaf liar slips in just to babble at you.";
	move oaf liar to we loan;
	print-the-loc;
	declue-here;

a wordtwisting rule (this is the pre-oh-flier rule):
	if player is not in we loan, unavailable;
	if oaf liar is not in we loan, unavailable;
	if sco-six-quid is false:
		vcp "[one of]You notice a flier behind their back, and you nudge them as if to say, can I have it for free? No, no, you cannot[or]You still haven't found any way to pay for the flier[stopping].";
		not-yet;
	if current-quid > 1:
		vcp "[opflier]You try and pull out one quid, but you wind up pulling them all out. The oaf liar's eyes get big. And you instinctively say, no, I'm not getting taken like that.[paragraph break]'Have it your way. Information's valuable. Don't try to lowball me.'";
		not-yet;
	ready;

this is the hom-owe-flier rule:
	say "You don't owe the oaf liar anything, and they don't owe you a flier, even if they might be wasting your time. How to call attention to a flier, though?"

to say opflier:
	now gs-overpay-flier is true;

this is the post-oh-flier rule:
	now sco-oh-flier is true;
	if gs-overpay-flier is true:
		say "You offer the only quid you have left. The oaf liar, being a liar, suspects you're being a liar, too. They demand you show proof you couldn't possibly have any more money on you. After all, you did before![paragraph break]You feel guilty about the subterfuge of spending money elsewhere and coming back, but then again, the oaf liar has their own sales tricks, you're sure. You stood your ground in negotiations, and that's something. You hope the flier is worth it.";
	else:
		say "You act distracted just right. The oaf liar tries to get your attention. Just ignoring them wouldn't work, but paying attention to a flier ... well, they take the hint that you aren't a high-rolling customer. They try to wheedle more money out of you, but of course, that's all you have. So you trade your final quid for the flier. The oaf liar thanks you for not totally wasting their time. They seem to snicker as they depart.";
	moot oaf liar;
	now player has flier;
	quid-reduce 1;
	print-the-loc;

section keepiller scoring

a wordtwisting rule (this is the pre-gnome-old rule):
	if player is not in keepiller, unavailable;
	if sco-wool-frock is false:
		vcp "You summon a gnome, old, to compliment them on keeping the keep looking so nice all these years. They thank you but mention they're a bit sick of it and they seek adventure. Yet they can't go adventuring in these tatty clothes.";
		not-yet;
	if sco-gnome-old is true:
		vcal "You already summoned the gnome!";
		already-done;
	ready;

this is the post-gnome-old rule:
	now sco-gnome-old is true;
	say "A gnome, old, arrives from a room above in the keep. They offer to adventure with you, if you have suitable enough adventuring gear. As a matter of fact, you do. The wool frock works well.[paragraph break]'Less gnome attic, more nomadic,' they muse.[paragraph break]Funnily, you stop specifically noticing the lack of mold now your new companion's joined you. But you still appreciate their efforts deep down!";
	moot mold;
	befriend gnome old;
	moot wool frock; [now gnome has wool frock?]

a wordtwisting rule (this is the pre-rogue-old rule):
	if player is not in keepiller, unavailable;
	if sco-six-quid is false:
		vcp "A rogue, old, appears, but after some conversation, you realize you don't have any money to pay them with. They'd like to help, but they worked for free once and felt ripped off. Maybe later.";
		not-yet;
	if sco-rogue-old is true:
		vcal "But you already got the rogue (old) to join you!";
		already-done;
	ready;

this is the hom-rouge-old rule:
	say "Rouge ... no, too foreign, also, too abstract. But you need a person, not a color. That'll get you a point in this game, not just Canadian football."

this is the post-rogue-old rule:
	now sco-rogue-old is true;
	say "A rogue, old, arrives. They mention they'd like to help you but, you know, the row (gold) needs maintenance. You offer to pay them three quid.";
	befriend rogue old;
	declue row gold;
	quid-reduce 3;

to quid-reduce (nu - a number):
	say "[line break]This transaction reduces your wealth from [current-quid in words] quid to [(current-quid - nu) in words] quid.";
	decrease current-quid by nu;
	if current-quid is 0:
		say "[line break]Well, easy come, easy go. You're pretty sure you've visited everywhere and found everyone who might need money.";

a wordtwisting rule (this is the pre-manna-curb rule):
	if player is not in keepiller, unavailable;
	if sco-mensch-elf is false:
		vcp "Perhaps there is a lot of good stuff beneath the manic herb, but you don't have the specialized knowledge to figure it out.";
		not-yet;
	if sco-manna-curb is true:
		vcal "You already found enough manna beneath the manic herb!";
		already-done;
	ready;

this is the hom-mana-curb rule:
	say "You do not have any magic points, so you don't need them refreshed. But you must be close! Like, just one letter off!"

this is the post-manna-curb rule:
	now sco-manna-curb is true;
	say "You suspect there is manna beneath the manic herb, but you have no clue how to find it. Thankfully, the mensch elf steps up. You wind up with a lot of manna, whatever that is!";
	now player has manna;
	declue manic herb;

a wordtwisting rule (this is the pre-plan-tracker rule):
	if player is not in keepiller or plant racker is not touchable, unavailable;
	ready;

this is the post-plan-tracker rule:
	now sco-plan-tracker is true;
	say "Wow! That was ... surprisingly simple. You find a rather new-looking plan tracker behind the plant racker, which crumbles to dust as you push it aside.";
	moot plant racker;
	now player has plan tracker;

this is the hom-c-sea-design rule:
	say "Close, but there are other waterways. Action (well, sort of) is needed here."

a wordtwisting rule (this is the pre-see-design rule):
	if player is not in keepiller, unavailable;
	if pals-made < 2:
		vcp "You sort of want to see the hidden design, but you're sort of scared what will happen once you do. [if pals-made is 1][The random friendly follower] can only help so much. [end if]You feel like you need some [if pals-made is 1]more [end if]support before you can give it your all.";
		not-yet;
	if sco-see-design is true:
		vcal "You already saw the design in the seedy sign. You don't need to redo things.";
		already-done;
	ready;

this is the post-see-design rule:
	now sco-see-design is true;
	now block-followers is true;
	say "You see the design in the seedy sign. It leads somewhere scary. Somewhere you don't want your friends to visit. Though you appreciate their support. You'll be right back. You think. You hope.";
	declue seedy sign;
	move player to Nigh Fright;

section nigh fright scoring

a wordtwisting rule (this is the pre-knife-right rule):
	if player is not in nigh fright, unavailable;
	ready;

this is the post-knife-right rule:
	now sco-knife-right is true;
	say "With your friends boosting your spirits, you look for a sacred/profane weapon. It turns up. Eerie howling begins. You hightail it out of there.";
	now player has knife right;
	now block-followers is false;
	declue-here;
	drop-player-at KeepIller;

section worm eaten scoring

a wordtwisting rule (this is the pre-gaunt-raider rule):
	if player is not in worm eaten or gone traitor is not in worm eaten, unavailable;
	ready;

this is the hom-gaunt-rater rule:
	say "Hmm. You need someone much more active than that. Someone who can help with rebellion, not just whine about things that are wrong."

this is the post-gaunt-raider rule:
	now sco-gaunt-raider is true;
	say "After some discussion, you work out a plan to make the gone trader reframe what they did. Whoever they were, the evil powers, they rejected them instead of doubling down. Perhaps there is a way to get back at them. They know things you never could hope to.";
	moot gone traitor;
	befriend gaunt raider;

a wordtwisting rule (this is the pre-were-meetin rule):
	if player is not in worm eaten, unavailable;
	if sco-were-meetin is true:
		vcal "You already held a meeting! Too many meetings get in the way of doing.";
		already-done;
	abide by the followers-check rule;
	ready;

a wordtwisting rule (this is the followers-check rule):
	if pals-made is 0:
		vcp "Sadly, you have no friends to bring together yet! Yet.";
		not-yet;
	if number of still-follow-needed followers > 0:
		vcp "You sense you don't have the gang together! [if number of still-follow-needed followers is 1]But you must be very, very close[else]You may still be a way away[end if].";
		not-yet;

this is the hom-whirr-meetin rule:
	if the player's command includes "meeting":
		say "That sounds a bit too informal and serious. Especially since the room has no ending g.";
	else if the player's command includes "whirr":
		say "Close, but you don't need a whirr noise.";
	else:
		say "You don't need to change this place's complexion here. It's cozy, a place for people to be together. But how?"

this is the post-were-meetin rule:
	now sco-were-meetin is true;
	say "You meet with the friends you've made over your adventure. You all have one goal in mind. And yet you don't have a rallying cry. Perhaps it can come from within you.";
	print-the-loc;
	declue-here;

section worm eaten scoring

a wordtwisting rule (this is the pre-my-corps rule):
	if sco-an-aim is false, unavailable;
	abide by the followers-check rule;
	if sco-my-corps is true:
		vcal "You already brought your corps a bit closer together!";
		already-done;
	if sco-treat-all is false:
		vcp "They are your corps, and yet, there's something to share with them. Something to enjoy together, first.";
		not-yet;
	if player is not in worm eaten:
		vcp "This doesn't seem to be the right place to pep up the troops.";
		not-yet;
	if sco-were-meetin is false:
		vcp "You sense you have a full party, and you're in a good place, but the atmosphere is wrong for planning and discussions.";
		not-yet;
	ready;

this is the hom-my-core rule:
	say "You always want to strengthen your own core, but you have a feeling you're looking too inward, here. Though you must be close."

this is the post-my-corps rule:
	now sco-my-corps is true;
	say "Your pep talk brings everyone together. You worry it's too simplistic, especially 'titan's lairs? Titan slayers!'";
	say "[line break]But everyone seems enthused, ready for what happens next. Gathering information from everyone, you start diggint to find tunnels below. You clear out a passage below. You swear a solemn pact that everyone will defend everyone else, regardless of what happens.";
	now Doom Ending is mapped below Worm Eaten;
	declue Mike Orr;

chapter Doom Ending scoring

a wordtwisting rule (this is the pre-cease-cull rule):
	if player is not in Doom Ending or sea skull is not in Doom Ending, unavailable;
	if sco-cease-cull is true:
		vcal "You already played defense. Now's the time to go on offense!";
		already-done;
	ready;

this is the hom-cease-cull rule:
	if the player's command includes "seize":
		say "No, seizing is the last thing you want the skull to do. And you aren't foolish enough to want to seize power.";
	else:
		say "You don't need to see more seas. In fact, you need things to settle down."

this is the post-cease-cull rule:
	now sco-cease-cull is true;
	say "You'll probably have to alert the sea skull to your presence at some time. You try to sound authoritative when you do so. And ... well, you get its attention.[paragraph break]'DONE, OH?!?! DUH, NO!' it roars.[paragraph break]It begins pouring out rivers of blood at you and your companions. But fortunately, you have so many, that by the time it gets to you, it is not so bad. Yet it's still depressing. You think back to advice you got at the beginning ... how it seemed slightly off. What to do?";
	now eyes-number of skull is 43;

a wordtwisting rule (this is the pre-wide-vision rule):
	if player is not in doom ending, unavailable;
	if why division is not in doom ending, unavailable;
	if pre-acts < pre-max:
		vcp "[remove-widevision-bonus][one of]You try to declare a wide vision, but as you do, you trip yourself up on pronunciation. Wide vision? Why division? You worry you haven't fought through enough to have a truly wide vision--sure, you solved all the puzzles you needed to, but you feel like you're missing some necessary experience and struggle you need for true, long-term leadership.[paragraph break]But surely you must give it a try![paragraph break][entry thinkcue-index of wide-vision-rejects][war-pawn-musings][or]You are unable to express your wide vision. You'll have to settle for just repairing things pretty well.[line break][stopping]";
		not-yet;
	ready;

to say war-pawn-musings:
	say "[paragraph break]'I? Low. I'll ... oh ...' you moan, preparing to bare your guilty soul.[paragraph break]";
	if gs-war-pawn-try is true:
		say "'Oh! Must be that I [if gs-war-pawn-used is true]used[else]tried to use[end if] that war pawn. Lesson learnt.'[paragraph break]But your companions change to I-saw-ice-aww expressions. No, it must have been something else.";
	else:
		say "You ask for credit because you didn't use the war pawn, but that seems irrelevant. They didn't know you had one!";
	say "[line break]'It was BRUISE-WARES, wasn't it?' you ask. 'I shouldn't have [if sco-brew-swears is false]ignored it[else if brew swears is unvisited]chickened out from going in[else if brew-swears-score is 1]left just as I got there[else if brew-swears-score is 2]left the crude orc[else if brew-swears-score is 3]chickened out right after I rescued the crude orc[else if brew-swears-score < 9]left things undone[else]enjoyed tearing through it all[end if].'[paragraph break]Your companions shake their heads slightly.[paragraph break]";

to say remove-widevision-bonus:
	if gs-penalized-why-division is false:
		decrement cur-max-bonus;
		now gs-penalized-why-division is true;

this is the post-wide-vision rule:
	now sco-wide-vision is true;
	moot why division;
	say "Your experiences and failures give you a leadership you don't know you had. You convince your companions to do more than just save their own hides. You lay out a vision so scourges from the likes of the sea skull are less likely to happen again, or it will take longer. And everyone listens! A few even say 'Worth inking, we're thinking!'[paragraph break]They're eager for the final step, to get out there. You look around. It's pretty clear what must occur, or it will be, soon.";

a wordtwisting rule (this is the pre-do-due-mend rule):
	if player is not in Doom Ending, unavailable;
	if sco-wipe-out is false:
		vcp "You'll have to dispose of the sea skull first.";
		not-yet;
	ready;

this is the post-do-due-mend rule:
	now sco-do-due-mend is true;
	if sco-wide-vision is false:
		say "Yes. It's time to get healing. Your companions don't have as much time or energy to help as you hoped they would, but they do enough. Everyone feels better for their part in defeating the sea skull. And yet you worry it, or something like it, may be back sooner rather than later, and your companions have gone their separate ways for good. Still, you should be pleased with yourself.";
	else:
		say "You and your companions work together not just to make sure bad things won't happen right away, but to help prevent evil from spawning. Perhaps it will happen some day. But everyone remembers how they got sidetracked into irrelevance or worse, and they work to make sure others risk the same fate much less.";
	follow the score and thinking changes rule;
	end the story finally saying "[if sco-wide-vision is true]Beat all! Be tall![else]Gray day?! Grade A![end if]";
	follow the shutdown rules;

chapter brew swears scoring

a wordtwisting rule (this is the pre-weak-us rule):
	if player is not in brew swears, unavailable;
	if sco-weak-us is true:
		vcal "You already established [the grinch] cursed out of weakness or, at least, not fully from strength!";
		already-done;
	ready;

this is the post-weak-us rule:
	now sco-weak-us is true;
	say "You're surprised how just making a little shift can make [the grinch] seem much weaker. Their strength is the sort of brute force that doesn't lift other people up.[paragraph break]They throw down the gauntlet at this point. Don't you know cussing shows higher intelligence? Some study or other showed that!";
	check-orc-friendliness;
	follow the cycle swears rule;
	declue-here;

a wordtwisting rule (this is the pre-grin-churls rule):
	if player is not in brew swears, unavailable;
	if sco-grin-churls is true:
		vcal "You already cut [the grinch] down to size!";
		already-done;
	ready;

this is the post-grin-churls rule:
	now sco-grin-churls is true;
	say "You slip in a few sly digs and say 'grin, churls.' They shake their heads, annoyed.";
	grinch-go-check;
	declue grinch earls;

a wordtwisting rule (this is the pre-crew-dork rule):
	if player is not in brew swears, unavailable;
	if sco-weak-us is false:
		vcp "The crude orc doesn't believe they're being used by [the grinch]. Why, it's part of the hazing! They have to show they're tough!";
		not-yet;
	if sco-crew-dork is true:
		vcal "You already broke the truth to the crude orc as gently as you could!";
		already-done;
	ready;

this is the post-crew-dork rule:
	now sco-crew-dork is true;
	say "You break the truth gently to the crude orc that, well, they're at the bottom of the totem pole for this crew. They'll use the crude orc, maybe even not let them into the clique, and then find the next sucker. The [grinch] surprisingly have little response to this besides, well, profanity.";
	check-orc-friendliness;

to check-orc-friendliness:
	if orc-score is 2:
		say "[line break]The crude orc sees it now. [The earls] weren't as friendly as they seemed. They wanted to use some trusting kid and corrupt them. The crude orc shakes their head. They ask if they can be seen as an orc and not, well, a dork. You say sure.";
		say "[line break]You've gained a friend! [if grinch earls are moot]There's really nothing left to do here[else]You can stick around to torment the grinch earls further, or you can go on your way[end if].";
		befriend crude orc;
		declue crude orc;
	else if orc-score is 1:
		say "[line break]The crude orc looks back and forth between you and the [grinch], glaring at them a bit, but not yet ready to break free. Just a bit more, and you may gain a friend.";

section brew swears scoring

a wordtwisting rule (this is the pre-ass-low rule):
	if player is not in brew swears, unavailable;
	if aah-slow is not in brew swears, unavailable;
	ready;

this is the post-ass-low rule:
	now sco-ass-low is true;
	say "You aren't sure if you are pointing out how low they are, or how they say 'lo,' but either way ... it has an effect.";
	swearzap aah-slow;

a wordtwisting rule (this is the pre-huh-shit rule):
	if player is not in brew swears, unavailable;
	if hush-it is not in brew swears, unavailable;
	ready;

this is the post-huh-shit rule:
	now sco-huh-shit is true;
	say "You reject [the grinch]['] 'urbane' attempts at shutting you up. They're a bit surprised at you.";
	swearzap hush-it;

a wordtwisting rule (this is the pre-lie-fuckers rule):
	if player is not in brew swears, unavailable;
	if life-occurs is not in brew swears, unavailable;
	ready;

this is the post-lie-fuckers rule:
	now sco-lie-fuckers is true;
	say "You cut down [the grinch] for making things more bleak than they are. Sure, life can be cruel, but that's no excuse to make it even more cruel. They give a 'whatever,' but you see the point touched home.";
	swearzap life-occurs;

a wordtwisting rule (this is the pre-bastard-eee rule):
	if player is not in brew swears, unavailable;
	if bah-sturdy is not in brew swears, unavailable;
	ready;

this is the post-bastard-eee rule:
	now sco-bastard-eee is true;
	say "You show you're sturdy and then some, with just the right tone of exasperation. They pretend not to be impressed, but they don't have a comeback.";
	swearzap bah-sturdy;

a wordtwisting rule (this is the pre-heckle-ass rule):
	if player is not in brew swears, unavailable;
	if heh-class is not in brew swears, unavailable;
	ready;

this is the post-heckle-ass rule:
	now sco-heckle-ass is true;
	say "You give back at least as good as you got, showing you don't need to use the big cuss words to get a point in as well.";
	swearzap heh-class;

a wordtwisting rule (this is the pre-were-dicks rule):
	if player is not in brew swears, unavailable;
	if weird-icks is not in brew swears, unavailable;
	ready;

this is the post-were-dicks rule:
	now sco-were-dicks is true;
	say "You mock [the grinch] back, giving at least as good as you get, noting there's always a hole in these sorts of attacks.";
	swearzap weird-icks;

a wordtwisting rule (this is the pre-gah-wanker rule):
	if player is not in brew swears, unavailable;
	if Gawain Kerr is not in brew swears, unavailable;
	ready;

this is the post-gah-wanker rule:
	now sco-gah-wanker is true;
	say "'No, dude. Just, no,' says Gawain Kerr. 'I mean, it's different when I make fun of other people. I mean, if it's more profane, they deserve me to act like they were too clueless to notice it, and if it's less profane, well, it can't hurt.'[paragraph break]Not knowing what to do, you shrug.[paragraph break]'Cold of you. You know, you looked like such a nice person, but after saying that, well, you proved you're a liar. Unlike me. People know I'm risque. Anyway, you don't appreciate me, so there's no use me hanging around you.'[paragraph break]'You'll be sad one day you angered a Sofa King like me!'[paragraph break]Thankfully, you will have no way of seeing the, uh, new direction he will take.";
	moot Gawain Kerr;

section brew swears auxiliary

to recalibrate-swears:
	if number of not moot swearblobs is 0:
		say "[line break]The [grinch], out of insults, give up on it all, claiming you just make everything around more boring. But you know better.";
		grinch-go-check;
		continue the action;
	follow the cycle swears rule;

to remove-swear-bonus:
	if gs-swear-bonus-removed is false:
		decrease cur-max-bonus by (11 - brew-swears-score);
		now gs-swear-bonus-removed is true;

to swearzap (sw - a swearblob):
	moot sw;
	if number of not moot swearblobs > 0:
		now next-swear of (prev-swear of sw) is next-swear of sw;
		now prev-swear of (next-swear of sw) is prev-swear of sw;
	recalibrate-swears;

to grinch-go-check:
	if sco-grin-churls is true and number of not moot swearblobs is 0:
		say "[line break]The [grinch] remark that you seemed so open-minded, really, and they're all for a bit of banter, but they know when to fully move on from people like you who just don't shut up. So they do, with a 'Weak wit? We quit!' and, tailing off, 'We're stirred...'[paragraph break]But first they call in someone who they're sure can take care of you: GAWAIN KERR![paragraph break]On arriving, Gawain asks you your name. 'Pfft! Meeker? Oh. Mike OR. Sure ain't Mike AND, amirite?' You move to protest, but your party didn't follow you in.";
		moot grinch earls;
		move gawain kerr to Brew Swears;

volume command parsing

the check forks rule is listed first in the for printing a parser error rulebook.

rule for printing a parser error (this is the check forks rule):
	now partial-row is 0;
	now got-partial-done is false;
	abide by the main-wordtwisting-checker rule for table of main oronyms;
	[if mrlp is valid, abide by the main-wordtwisting-checker rule for spoontable of mrlp;]
	if partial-row > 0:
		if partial-now is true:
			say "A voice in your head encourages you: 'Seem, or see, more!' You've got SOMETHING right, here.";
		else:
			if debug-state is true:
				choose row partial-row in table of main oronyms;
				say "(DEBUG: [check-rule entry] tripped) ";
			say "Not much happens, but you feel like that might help, at least halfway, some time later. Much later, or just a little, you can't tell.";
		the rule succeeds;
	if got-partial-done is true:
		if debug-state is true, say "[partial-row] row ...";
		say "Hmm, no, you already did that, or something like that. You'll know if and when you need to flip between things.";
		the rule succeeds;
	continue the action;

check thinking when current-score is 0:
	say "An inner voice says 'Fry! Twist!' You feel fright, wist. It's hard not to, since you don't have a name or a purpose. For some reason, you're focused on getting a name, but you've got this nagging feeling that's not quite it.[paragraph break][one of]Perhaps if you press a bit more, some thoughts may come out[or]Well, not quite a purpose, but ... what's the word? [one of]'Aww, flake! Awful ache!'[or]'Dumb pit. Dump it!'[in random order] you think to yourself. Which sounds slightly off, but it's all you have to go on[stopping].";
	if pre-acts > 0:
		say "[line break]You've already tried to [b]WIPE OUT[r] in response to taunts of 'why pout,' and you wonder if this all is easier. [if gs-examined-self is false]Perhaps you should [b]X ME[r][else]Maybe your search for a name will turn up something meaningful, regardless of what your name is[end if].";
	the rule succeeds;

rule for printing a parser error when the latest parser error is the not a verb I recognise error or the latest parser error is the didn't understand error (this is the catch bad verbs rule):
	if core-score is 0:
		say "You're stuck with what to do right now. Perhaps you can use your senses for clues, or [b]THINK[r], or look inward[if gs-examined-self is true] again with X ME[end if], to give you an idea of how to get started. Not just a what, but a how or a why. You can't exactly look outward.";
		increment first-point-clue-flag;
		if gs-parser-error-note is false:
			say "[line break][i][bracket][b]NOTE[r][i]: until the main area, parser verb errors like this will give occasional general hints. So don't be afraid to try stuff.[close bracket][r][line break]";
			now gs-parser-error-note is true;
			the rule succeeds;
		increment counter-zero-points;
		if counter-zero-points > number of rows in table of zero point taunts:
			now counter-zero-points is 1;
		if first-point-clue-flag is 4:
			now first-point-clue-flag is 0;
			say "[line break][one of]A cruel voice mocks [or]That cruel voice, again. [stopping][one of]'Way to wait, ooh!'[or]'You'd be better off [b]WAIT[r]ing or typing nothing.'[or][random-taunt][stopping]";
	else if core-score is 1:
		say "You need to find something that will get you out of the tomb apse. You remembered a name (yours) by finding an aim. What now?";
	else if core-score is 2:
		say "Man! The chatter from those phones must be distracting you from what you want and need to do, or maybe see.";
	else if core-score is 3:
		say "The prize talk has you distracted. It's got a point: you need to find something to get where you want. What's the something? [where-get-hype]";
	else:
		say "That thought/action/observation/request brings up nothing. [this-game] has a limited set of verbs, and the main thing is to guess a two-word phrase. To see what verbs are used, try [b]VERBS[r].";
	the rule succeeds;

to say where-get-hype:
	choose row with check-rule of pre-high-plain rule in table of main oronyms;
	if think-cue entry is false:
		say "Where do you want to get?";
	else:
		say "You know where you want to get, the high plain/plane."

to say random-taunt:
	choose row counter-zero-points in table of zero point taunts;
	say "[taunt-text entry][if counter-zero-points is number of rows in table of zero point taunts] (that's the last of the specific hints.)";

table of zero point taunts
sortval	taunt-text
-3	"'Nothing you've tried has worked. You'd be better off [b]WAIT[r]ing or typing nothing.'"
-2	"'Find a fine day,' just like your original captors."
-1	"'Oh, fog, oaf! Augh!'"
0	"'Bro, clues? Broke! Lose!'"
0	"'Boost-op? Boo! Stop!'"
0	"'Duh, DO?! Dud, ooh!'"
0	"'Play some place, umm...'"
0	"'Be strong? Beast, WRONG!'"
1	"'Take a look where you are.'"

rule for printing a parser error when the latest parser error is the can't see any such thing error:
	say "Nothing here like that[one of]. Note that room names are not usually worth examining, as you can just [b]L[r] or [b]LOOK[r][or][stopping]."

volume can't go that way

table of noways
noway-rm	noway-txt
Eh Raw Air Aww	"[if sco-an-aim is false][one of]'Grey trek? Great wreck!' [or]'I sit? Ice it!' [stopping]you moon. You can't see anywhere. You know almost nothing. I mean, you don't even have a name. What would you do even if there was a passage?[else]It looks like there are ways out, but you're disoriented enough, directions don't matter. You sure would like a way to see where you're going.[end if]"
Hype Lane	"[if noun is not up]No sense faffing around horizontally. You're sick of being stuck underground[else if sco-pry-stalk is false]You need to find something that will help you go up[else]You need to name where to go up to[end if]."
NaffHaze	"[if sco-nah-phase is false]Too risky to stumble around until the haze lifts. How to make that happen?[else if number of viable directions is 0]You feel like eventually you should be able to wander around, but you can't see anywhere to go, yet. There seem to be clues where to go, and how, if you look around.[else if plane-dir-score is 4]You can go down or in the cardinal directions, but not [noun].[else]You can't go [noun], but you can go [list of viable directions].[end if]"
KeepIller	"Apart from finding a way beyond the seedy sign[if sco-see-design is true], which you don't need to again[end if], the keep doesn't have many twisty passages. Well, any."
Nigh Fright	"You could leave, but then you'd have to come back. Just figure what to do here."
Lobe End	"[if sco-low-bend is true]The bend only curves west to north[else]You can only go back west. Well, for now[end if]."
Storm Isle	"You can only go back south to Lobe End[if sco-store-mile is true] or north to the rest of the mall[end if]."
Trees Mall	"You can only go back south."
Wolf Rock	"Wolf Rock blocks every planar passage except back [b]SOUTH[r]. [if sco-low-door is true]Well, you can go [b]IN[r] where the lode ore was as well[else]Maybe something's under the lode ore as well--it's dense[end if][if sco-hide-out is true]. You discovered the hideout [b]DOWN[r], too[end if]." [??use is-thought here]
We Loan	"You can only go back [b]OUT[r] here."
Hideout	"You can only go back [b]UP[r]. If this hideout had too many passages, it'd risk being less effective."
NoNotion	"You can only go back [b]NORTH[r][if squid is in NoNotion] or, if you know where you want to go, give the squid instructions where to go[else], or that's your notion, right now[end if]."
Wand Wharf	"You're not in the mood for exploring the wharf randomly. It seems like a good way to get lost. Perhaps if you focus on a specific sort of companion you need nearby, that would be better. Then you could find them and leave."
Worm Eaten	"No tricky passages here, just [b]UP[r] back to safer ground or [b]DOWN[r] to your fate."
Doom Ending	"[if sco-wipe-out is true]You need to prep for making things right in general. Then, once the game's over, you'll leave[else]Unsurprisingly, all the action is here[end if]."
Brew Swears	"You don't want to get into the guts of this place. [if sco-crew-dork is true]You've gotten the crude orc on your side, and the only way to go is[else]Just get the crude orc, if you'd like, then get[end if] [b]OUT[r]."

volume scoring to move [see RoL Defs if I add bonus points]

the score and thinking changes rule is listed instead of the notify score changes rule in the turn sequence rulebook.

this is the score and thinking changes rule:
	let sco-delt be current-score - last-current-score;
	let bonus-delt be cur-bonus - last-cur-bonus;
	if sco-delt is 0 and bonus-delt is 0, continue the action;
	if bonus-delt > 0:
		say "[i][bracket]Your score just went up by [if bonus-delt is 1]a bonus point[else][bonus-delt in words] bonus points[end if]![close bracket][r][line break]";
		now last-cur-bonus is cur-bonus;
		now last-current-score is last-current-score + bonus-delt;
		now sco-delt is sco-delt - bonus-delt;
	if sco-delt > 0:
		if bonus-delt > 0, say "[line break]";
		say "[i][bracket]Your score just went up by [if sco-delt is 1]a point[else][sco-delt in words] points[end if]![close bracket][r][line break]";
		now last-current-score is current-score;

Why Pout Tables ends here.

---- DOCUMENTATION ----
